<?php
/**
 * Footer buttons markup file.
 *
 * @package colormag
 *
 * TODO: @since.
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$button_enable = get_theme_mod( 'colormag_enable_footer_button' );

$button_text   = get_theme_mod( 'colormag_footer_button_text', 'Button' );
$button_link   = get_theme_mod( 'colormag_footer_button_link' );
$button_target = get_theme_mod( 'colormag_footer_button_target' ) ? ' target="_blank"' : '';

if ( $button_text ) :
	?>
	<div class="cm-footer-buttons">
		<?php
		do_action( 'colormag_footer_button_start' );

		if ( $button_text ) {
			?>

			<div class="cm-footer-button cm-footer-button--1">
				<a class="cm-button" href="<?php echo esc_url( $button_link ); ?>"
					<?php echo esc_attr( $button_target ); ?>
					class="<?php echo colormag_css_class( 'colormag_footer_button_class', false ); ?>">
					<?php echo esc_html( $button_text ); ?>
				</a>
			</div>

			<?php
		}

		do_action( 'colormag_footer_button_end' );
		?>

	</div> <!-- /.cm-footer-buttons -->
	<?php
endif;
